/* -*-c++-*- Copyright (C) 2018 Advanced Driver Information Technology.
 *
 * This library is open source and may be redistributed and/or modified under
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * OpenSceneGraph Public License for more details.
*/

#include "WLKeyboard.hpp"
#include "WLSurfaceEvent.hpp"

using namespace WaylandBackend;

const struct wl_keyboard_listener WLKeyboard::_keyboardListener =
{
        WLKeyboard::keyboardHandleKeymap,
        WLKeyboard::keyboardHandleEnter,
        WLKeyboard::keyboardHandleLeave,
        WLKeyboard::keyboardHandleKey,
        WLKeyboard::keyboardHandleModifiers,
        WLKeyboard::keyboardHandleRepeatInfo
};


WLKeyboard::WLKeyboard(struct wl_seat *wlSeat, struct wl_event_queue *eventQ):
_wlKeyboard(NULL)
,_wlSeat(wlSeat)
,_keyboardFocus(NULL)
{
    if (NULL != eventQ)
    {
        struct wl_seat* wrappedSeat = (struct wl_seat*)
                                wl_proxy_create_wrapper((void *)wlSeat);
        if (NULL != wrappedSeat)
        {
            wl_proxy_set_queue((struct wl_proxy*)wrappedSeat, eventQ);
            _wlKeyboard = (struct wl_keyboard*)
                           wl_seat_get_keyboard(wrappedSeat);

            wl_proxy_wrapper_destroy(wrappedSeat);
        }
    }
    else
    {
        /*
         * It is not good idea to use default queue. default queue can be
         * dispatched by multiple threads
         */
        _wlKeyboard = (struct wl_keyboard*) wl_seat_get_keyboard(wlSeat);
    }
    if (NULL != _wlKeyboard)
        wl_keyboard_add_listener(_wlKeyboard, &_keyboardListener, (void*)this);
}

void
WLKeyboard::clearIfFocusMatches(struct wl_surface *wlSurface)
{
    if (_keyboardFocus == wlSurface)
        _keyboardFocus = NULL;
}

void
WLKeyboard::keyboardHandleEnter(void* data, struct wl_keyboard* keyboard,
                                uint32_t serial, struct wl_surface* surface,
                                struct wl_array* keys)
{
    WLKeyboard *pwlKeyboard = static_cast<WLKeyboard*>(data);
    WLSurfaceEvent *pInputlistener;
    if (NULL != surface)
    {
        pInputlistener = static_cast<WLSurfaceEvent *>
                         (wl_surface_get_user_data(surface));

        if (NULL != pInputlistener)
            pInputlistener->keyboardEnter((void*)pwlKeyboard->_wlSeat,
                                          serial, keys);
    }
    pwlKeyboard->_keyboardFocus = surface;
}

void
WLKeyboard::keyboardHandleKeymap(void* data, struct wl_keyboard* keyboard,
                                 uint32_t format, int fd, uint32_t size)
{
    WLKeyboard *pwlKeyboard = static_cast<WLKeyboard*>(data);
    WLSurfaceEvent *pInputlistener;
    if (NULL != pwlKeyboard->_keyboardFocus)
    {
        pInputlistener = static_cast<WLSurfaceEvent *>
                       (wl_surface_get_user_data(pwlKeyboard->_keyboardFocus));

        if (NULL != pInputlistener)
            pInputlistener->keyboardKeymap((void*)pwlKeyboard->_wlSeat,
                                           format, fd, size);
    }
}

void
WLKeyboard::keyboardHandleModifiers(void* data, struct wl_keyboard* keyboard,
                                    uint32_t serial, uint32_t mods_depressed,
                                    uint32_t mods_latched,
                                    uint32_t mods_locked, uint32_t group)
{
    WLKeyboard *pwlKeyboard = static_cast<WLKeyboard*>(data);
    WLSurfaceEvent *pInputlistener;
    if (NULL != pwlKeyboard->_keyboardFocus)
    {
        pInputlistener = static_cast<WLSurfaceEvent *>
                       (wl_surface_get_user_data(pwlKeyboard->_keyboardFocus));
        if (NULL != pInputlistener)
            pInputlistener->keyboardModifiers((void*)pwlKeyboard->_wlSeat,
                                              serial, mods_depressed,
                                              mods_latched, mods_locked,
                                              group);
    }
}

void
WLKeyboard::keyboardHandleKey(void* data, struct wl_keyboard* keyboard,
                              uint32_t serial, uint32_t time, uint32_t key,
                              uint32_t state_w)
{
    WLKeyboard *pwlKeyboard = static_cast<WLKeyboard*>(data);
    WLSurfaceEvent *pInputlistener;
    if (NULL != pwlKeyboard->_keyboardFocus)
    {
        pInputlistener = static_cast<WLSurfaceEvent *>
                       (wl_surface_get_user_data(pwlKeyboard->_keyboardFocus));
        if (NULL != pInputlistener)
            pInputlistener->keyboardKey((void*)pwlKeyboard->_wlSeat, serial,
                                        time, key, state_w);
    }
}

void
WLKeyboard::keyboardHandleLeave(void* data, struct wl_keyboard* keyboard,
                                uint32_t serial, struct wl_surface* surface)
{
    WLKeyboard *pwlKeyboard = static_cast<WLKeyboard*>(data);
    WLSurfaceEvent *pInputlistener;
    if (NULL != pwlKeyboard->_keyboardFocus)
    {
        pInputlistener = static_cast<WLSurfaceEvent *>
                       (wl_surface_get_user_data(pwlKeyboard->_keyboardFocus));
        if (NULL != pInputlistener)
            pInputlistener->keyboardLeave((void*)pwlKeyboard->_wlSeat, serial);
    }
}

void
WLKeyboard::keyboardHandleRepeatInfo(void* data, struct wl_keyboard* keyboard,
                                     int32_t rate, int32_t delay)
{
    WLKeyboard *pwlKeyboard = static_cast<WLKeyboard*>(data);
    WLSurfaceEvent *pInputlistener;
    if (NULL != pwlKeyboard->_keyboardFocus)
    {
        pInputlistener = static_cast<WLSurfaceEvent *>
                       (wl_surface_get_user_data(pwlKeyboard->_keyboardFocus));
        if (NULL != pInputlistener)
            pInputlistener->keyboardRepeatInfo((void*)pwlKeyboard->_wlSeat,
                                                rate, delay);
    }
}

WLKeyboard::~WLKeyboard()
{
    if (NULL != _wlKeyboard)
        wl_keyboard_release(_wlKeyboard);
}
